// Filter Glow
__kernel void filter_Glow(__read_only image2d_t image,   		// image image
						  __global uchar4* blur,     			// input blur table
						  __write_only image2d_t retImage,   	// image result
						  __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

	if(w>=width||h>=height)
		return;	

	float factor = (float)(alpha)/100.0f;
	float4 color = read_imagef(image, sampler, (int2)(w, h));	
	uchar sr = color.x * 255;
	uchar sg = color.y * 255;
	uchar sb = color.z * 255;
	uchar sa = color.w * 255;
	
	int offset = h * width + w;
	uchar bb = blur[offset].s0;
	uchar bg = blur[offset].s1;
	uchar br = blur[offset].s2;
	uchar ba = blur[offset].s3;
	
	uchar b = (uchar)(255 - ((255 - sb) * (255 - bb)) / 255.0f * factor + (1.0f - factor) * sb);
	uchar g = (uchar)(255 - ((255 - sg) * (255 - bg)) / 255.0f * factor + (1.0f - factor) * sg);
	uchar r = (uchar)(255 - ((255 - sr) * (255 - br)) / 255.0f * factor + (1.0f - factor) * sr);
	uchar a = (uchar)(255 - ((255 - sa) * (255 - ba)) / 255.0f * factor + (1.0f - factor) * sa);
	
	write_imagef(retImage, (int2)(w, h), (float4)(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f));
}

// Filter Holiday
__kernel void filter_Holiday(__read_only image2d_t image,   		// image image
						     __global int* TableR,     				// input buffer table R
							 __global int* TableG,     				// input buffer table G
							 __global int* TableB,     				// input buffer table B
							 __write_only image2d_t retImage,   	// image result
							 __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	
	if(w>=width||h>=height)
		return;
	float factor = (float)(alpha)/100.0f;
	float4 color = read_imagef(image, sampler, (int2)(w, h));
	uchar sr = color.x * 255;
	uchar sg = color.y * 255;
	uchar sb = color.z * 255;
		
	int r = TableR[sr];
	int g = TableG[sg];
	int b = TableB[sb];
		
	r = (int)(r * factor + sr * (1.0f - factor));
	g = (int)(g * factor + sg * (1.0f - factor));
	b = (int)(b * factor + sb * (1.0f - factor));
		
	write_imagef(retImage, (int2)(w, h), (float4)(r / 255.0f, g / 255.0f, b / 255.0f, color.w));
}

// Filter Narrow
#define LWAInt(aInt) ((aInt) & 0xFFFF)
#define HIAInt(aInt) (((aInt) >> 16) & 0xFFFF)

__kernel void filter_Narrow(__read_only image2d_t image,   		// image image
						    __global int* Table,     			// input buffer table
							__write_only image2d_t retImage,   	// image result
							__private int linePixels,
							__private int alpha)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	
	if(w>=width||h>=height)
		return;

	float factor = (float)(alpha)/100.0f;
	float4 color0 = read_imagef(image, sampler, (int2)(w, h));
	int offset = h * width + (width - 1 - w);
	int pos = Table[offset];
	int positon = HIAInt(pos) * linePixels + LWAInt(pos);
	float4 color1 = read_imagef(image, sampler, (int2)(width - 1 - positon % width, positon / width));
	
	color1 = color1 * factor + color0 * (1.0f - factor);
	
	write_imagef(retImage, (int2)(w, h), color1);
}